#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Smooth Voronoi ExperimentMod01.fsh   by  oneshade  
//https://www.shadertoy.com/view/stBGzm
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Alternative by iq suggested by Shane
// Its associative and commutative
// Associative: sminExp(a, sminExp(b, c, k), k) = sminExp(sminExp(a, b, k), c, k)
// Commutative: sminExp(a, b, k) = sminExp(b, a, k)
float sminExp(in float a, in float b, in float k) {
    float res = exp(-k * a) + exp(-k * b);
    return -log(res) / k;
}

// Hash from "Hash without Sine" by Dave_Hoskins (https://www.shadertoy.com/view/4djSRW)
float Hash11(in float x) {
    x = fract(x * 0.1031);
    x *= x + 33.33;
    x *= x + x;
    return fract(x);
}

// Random cycling points
vec2 getPoint(in vec2 cell) {
    float freq = Hash11(dot(cell, vec2(393.84, 673.48))) * 3.0 + 1.0;
    float phase = Hash11(dot(cell, vec2(348.46, 183.37)));
    float amp = Hash11(dot(cell, vec2(275.35, 741.69)));

    float t = iTime * freq + phase;
    return cell + 0.5 + 0.5 * vec2(cos(t), sin(t)) * amp;
}

float smoothVoronoi(in vec2 p, in float k) {
    // Get closest point
    vec2 cell = floor(p), closest = getPoint(cell);
    float minDist = length(p - closest);
    for (int i=-1; i < 2; i++) {
        for (int j=-1; j < 2; j++) {
            if (i == 0 && j == 0) continue;
            vec2 curCell = cell + vec2(i, j), curPoint = getPoint(curCell);
            float dist = length(p - curPoint);
            if (dist < minDist) {
                closest = curPoint;
                minDist = dist;
            }
        }
    }

    // Get closest border (should be doing 5x5 search but it doesn't affect this look)
    cell = floor(closest);
    vec2 p1 = getPoint(cell + 1.0);
    float dist = dot(p - 0.5 * (closest + p1), normalize(closest - p1));
    for (int i=-1; i < 2; i++) {
        for (int j=-1; j < 2; j++) {
            if ((i == 0 && j == 0) || (i == 1 && j == 1)) continue;
            vec2 curPoint = getPoint(cell + vec2(i, j));
            dist = sminExp(dist, dot(p - 0.5 * (closest + curPoint), normalize(closest - curPoint)), k);
        }
    }

    return dist;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    vec2 uv = (fragCoord - 0.5 * iResolution.xy) / iResolution.y * 3.0 + 0.5 * iTime;
    float unit = 6.0 / iResolution.y;

    float k = 13.0; // How much the tiles are packed
    float voro = smoothVoronoi(uv, k);

    float dx = (smoothVoronoi(uv + vec2(0.001, 0.0), k) - voro) / 0.001;
    float dy = (smoothVoronoi(uv + vec2(0.0, 0.001), k) - voro) / 0.001;
    vec3 grad = normalize(vec3(dx, dy, 1.0));

    fragColor = vec4(0.0);

    fragColor.gb += 0.5 + 0.5 * grad.xy;
    fragColor.r += grad.z;

    fragColor.rgb -= smoothstep(unit, 0.0, voro);
    fragColor.rgb += pow(grad.z, 10.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

